package gov.va.med.mhv.admin.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.admin.model.Employee;

@Repository
public interface EmployeeRepository extends JpaRepository<Employee, Long> {

	@Query("select distinct e from Employee e  where lower(e.userName) = lower(:userName)")
	public Employee findEmployeeByUserName(@Param("userName") String userName);

}
